
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="bananas", lb=0)
    x1 = model.addVar(name="bowls of instant ramen", lb=0)
    x2 = model.addVar(name="hamburgers", lb=0)
    x3 = model.addVar(name="corn cobs", lb=0)
    x4 = model.addVar(name="sashimi", lb=0)

    # Objective function
    model.setObjective(5.58*x0 + 7.86*x1 + 7.31*x2 + 4.54*x3 + 7.58*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11*x1 + 12*x4 >= 51)
    model.addConstr(6*x0 + 24*x3 >= 69)
    model.addConstr(6*x0 + 8*x2 >= 61)
    model.addConstr(8*x2 + 12*x4 >= 86)
    model.addConstr(6*x0 + 11*x1 + 8*x2 + 24*x3 + 12*x4 >= 86)
    model.addConstr(25*x0 + 7*x2 >= 81)
    model.addConstr(2*x1 + x4 >= 72)
    model.addConstr(2*x1 + 7*x2 >= 83)
    model.addConstr(9*x3 + x4 >= 54)
    model.addConstr(7*x2 + x4 >= 52)
    model.addConstr(2*x1 + 9*x3 >= 103)
    model.addConstr(7*x2 + 9*x3 >= 93)
    model.addConstr(25*x0 + 2*x1 + 7*x2 >= 85)
    model.addConstr(2*x1 + 7*x2 + x4 >= 85)
    model.addConstr(2*x1 + 9*x3 + x4 >= 85)
    model.addConstr(25*x0 + 2*x1 + 9*x3 >= 85)
    model.addConstr(7*x2 + 9*x3 + x4 >= 85)
    model.addConstr(25*x0 + 2*x1 + x4 >= 85)
    model.addConstr(25*x0 + 7*x2 + x4 >= 85)
    model.addConstr(25*x0 + 2*x1 + 7*x2 >= 116)
    model.addConstr(2*x1 + 7*x2 + x4 >= 116)
    model.addConstr(2*x1 + 9*x3 + x4 >= 116)
    model.addConstr(25*x0 + 2*x1 + 9*x3 >= 116)
    model.addConstr(7*x2 + 9*x3 + x4 >= 116)
    model.addConstr(25*x0 + 2*x1 + x4 >= 116)
    model.addConstr(25*x0 + 7*x2 + x4 >= 116)
    model.addConstr(-8*x1 + 10*x4 >= 0)
    model.addConstr(-x2 + 6*x3 >= 0)
    model.addConstr(6*x0 + 8*x2 <= 382)
    model.addConstr(11*x1 + 12*x4 <= 456)
    model.addConstr(8*x2 + 12*x4 <= 386)
    model.addConstr(6*x0 + 12*x4 <= 215)
    model.addConstr(11*x1 + 8*x2 <= 229)
    model.addConstr(6*x0 + 11*x1 <= 277)
    model.addConstr(11*x1 + 8*x2 + 12*x4 <= 306)
    model.addConstr(11*x1 + 24*x3 + 12*x4 <= 255)
    model.addConstr(6*x0 + 8*x2 + 24*x3 <= 247)
    model.addConstr(25*x0 + x4 <= 387)
    model.addConstr(25*x0 + 7*x2 <= 136)
    model.addConstr(2*x1 + 9*x3 <= 518)
    model.addConstr(2*x1 + 7*x2 <= 348)
    model.addConstr(25*x0 + 9*x3 + x4 <= 292)
    model.addConstr(25*x0 + 2*x1 + x4 <= 286)
    model.addConstr(2*x1 + 9*x3 + x4 <= 131)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Bananas:", x0.varValue)
        print("Bowls of instant ramen:", x1.varValue)
        print("Hamburgers:", x2.varValue)
        print("Corn cobs:", x3.varValue)
        print("Sashimi:", x4.varValue)
        print("Objective function value:", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
