
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
    candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")

    # Set objective function
    m.setObjective(1.81 * diapers + 3.86 * candles, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4 * diapers + 7 * candles >= 22, "weight_lower_bound")
    m.addConstr(1 * diapers + 3 * candles >= 17, "sustainability_lower_bound")
    m.addConstr(6 * diapers + 7 * candles >= 40, "usefulness_lower_bound")
    m.addConstr(4 * diapers + 1 * candles >= 25, "portability_lower_bound")
    m.addConstr(8 * diapers - 3 * candles >= 0, "custom_constraint")
    m.addConstr(4 * diapers + 7 * candles <= 44, "weight_upper_bound")
    m.addConstr(1 * diapers + 3 * candles <= 26, "sustainability_upper_bound")
    m.addConstr(6 * diapers + 7 * candles <= 71, "usefulness_upper_bound")
    m.addConstr(4 * diapers + 1 * candles <= 29, "portability_upper_bound")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('diapers:', diapers.x)
        print('candles:', candles.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
