
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="diapers")
x2 = m.addVar(vtype=GRB.INTEGER, name="candles")

# Set the objective function
m.setObjective(1.81*x1 + 3.86*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 7*x2 >= 22, "weight_min")
m.addConstr(4*x1 + 7*x2 <= 44, "weight_max")
m.addConstr(x1 + 3*x2 >= 17, "sustainability_min")
m.addConstr(x1 + 3*x2 <= 26, "sustainability_max")
m.addConstr(6*x1 + 7*x2 >= 40, "usefulness_min")
m.addConstr(6*x1 + 7*x2 <= 71, "usefulness_max")
m.addConstr(4*x1 + x2 >= 25, "portability_min")
m.addConstr(4*x1 + x2 <= 29, "portability_max")
m.addConstr(8*x1 - 3*x2 >= 0, "diapers_candles_ratio")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Diapers: {x1.x}")
    print(f"Candles: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
