
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="candles", vtype=gurobi.GRB.INTEGER)

# Objective function: minimize 1.81 * diapers + 3.86 * candles
model.setObjective(1.81 * x1 + 3.86 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(4 * x1 + 7 * x2 >= 22, name="weight_constraint")
model.addConstr(1 * x1 + 3 * x2 >= 17, name="sustainability_constraint")
model.addConstr(6 * x1 + 7 * x2 >= 40, name="usefulness_constraint")
model.addConstr(4 * x1 + 1 * x2 >= 25, name="portability_constraint")
model.addConstr(8 * x1 - 3 * x2 >= 0, name="diapers_vs_candles_constraint")
model.addConstr(4 * x1 + 7 * x2 <= 44, name="weight_upper_bound")
model.addConstr(1 * x1 + 3 * x2 <= 26, name="sustainability_upper_bound")
model.addConstr(6 * x1 + 7 * x2 <= 71, name="usefulness_upper_bound")
model.addConstr(4 * x1 + 1 * x2 <= 29, name="portability_upper_bound")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Diapers: {x1.varValue}")
    print(f"Candles: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
