
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
chicken_drumsticks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")

# Set objective function
m.setObjective(1.79 * bagged_salads + 2.18 * chicken_drumsticks, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * bagged_salads + 8 * chicken_drumsticks >= 38, "calcium_min")
m.addConstr(7 * bagged_salads + 8 * chicken_drumsticks >= 37, "carbs_min")
m.addConstr(8 * bagged_salads - 2 * chicken_drumsticks >= 0, "bagged_salads_chicken_drumsticks_ratio")
m.addConstr(6 * bagged_salads + 8 * chicken_drumsticks <= 59, "calcium_max")
m.addConstr(7 * bagged_salads + 8 * chicken_drumsticks <= 62, "carbs_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of bagged salads: {bagged_salads.x}")
    print(f"Number of chicken drumsticks: {chicken_drumsticks.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

