
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="bagged_salads")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_drumsticks")

# Set the objective function
m.setObjective(1.79*x1 + 2.18*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 8*x2 >= 38, "calcium_lower_bound")
m.addConstr(7*x1 + 8*x2 >= 37, "carbohydrates_lower_bound")
m.addConstr(6*x1 + 8*x2 <= 59, "calcium_upper_bound")
m.addConstr(7*x1 + 8*x2 <= 62, "carbohydrates_upper_bound")
m.addConstr(8*x1 - 2*x2 >= 0, "linear_combination_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bagged salads: {x1.x}")
    print(f"Chicken drumsticks: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
