
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="bagged_salads", lb=0)  # bagged salads
    x2 = model.addVar(name="chicken_drumsticks", lb=0)  # chicken drumsticks

    # Objective function
    model.setObjective(1.79 * x1 + 2.18 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6 * x1 + 8 * x2 >= 38)  # calcium
    model.addConstr(7 * x1 + 8 * x2 >= 37)  # carbohydrates
    model.addConstr(8 * x1 - 2 * x2 >= 0)  # custom constraint
    model.addConstr(6 * x1 + 8 * x2 <= 59)  # max calcium
    model.addConstr(7 * x1 + 8 * x2 <= 62)  # max carbohydrates

    # Resource constraints (not directly needed as they are part of the bounds)
    # However, let's ensure we don't exceed the given resource limits directly
    model.addConstr(x1 <= 77 / 6)  # calcium limit for x1
    model.addConstr(x1 <= 124 / 7)  # carb limit for x1
    model.addConstr(x2 <= 77 / 8)  # calcium limit for x2
    model.addConstr(x2 <= 124 / 8)  # carb limit for x2

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Bagged Salads: ", x1.varValue)
        print("Chicken Drumsticks: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
