
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    knishes = model.addVar(lb=0, name="knishes")
    blueberry_pies = model.addVar(lb=0, name="blueberry_pies")
    ham_sandwiches = model.addVar(lb=0, name="ham_sandwiches")


    # Set objective function
    obj = 3.9*knishes**2 + 2.38*knishes*blueberry_pies + 3.84*knishes*ham_sandwiches + 1.0*blueberry_pies**2 + 6.7*blueberry_pies*ham_sandwiches + 5.99*ham_sandwiches**2 + 7.68*knishes + 6.25*blueberry_pies + 2.01*ham_sandwiches

    model.setObjective(obj, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*blueberry_pies + 20*ham_sandwiches >= 132, "c0")
    model.addConstr(10*knishes + 22*blueberry_pies >= 41, "c1")
    model.addConstr(8*blueberry_pies**2 - 9*ham_sandwiches**2 >= 0, "c2")
    model.addConstr(35*knishes + 10*blueberry_pies <= 312, "c3")
    model.addConstr(10*blueberry_pies**2 + 17*ham_sandwiches**2 <= 304, "c4")
    model.addConstr(35*knishes + 10*blueberry_pies + 17*ham_sandwiches <= 304, "c5")
    model.addConstr(5*knishes + 5*ham_sandwiches <= 176, "c6")
    model.addConstr(5*knishes + 31*blueberry_pies + 5*ham_sandwiches <= 141, "c7")
    model.addConstr(22*blueberry_pies**2 + 20*ham_sandwiches**2 <= 89, "c8")
    model.addConstr(10*knishes + 22*blueberry_pies <= 215, "c9")
    model.addConstr(10*knishes + 22*blueberry_pies + 20*ham_sandwiches <= 215, "c10")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
