
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("energy_optimization")

    # Create variables
    x0 = m.addVar(lb=0, name="magnesium")  # milligrams of magnesium
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_c")  # milligrams of vitamin C

    # Set objective function
    m.setObjective(7.49 * x0 + 3.26 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(14 * x0 + 1 * x1 >= 23, "c0")
    m.addConstr(10 * x0 - 8 * x1 >= 0, "c1")
    m.addConstr(14 * x0 + 1 * x1 == 67, "c2")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        print('Magnesium:', x0.x)
        print('Vitamin C:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

