
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="milligrams_of_magnesium")
x2 = m.addVar(vtype=GRB.INTEGER, lb=0, name="milligrams_of_vitamin_C")

# Set the objective function
m.setObjective(7.49*x1 + 3.26*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 + x2 >= 23, "energy_stability_index_min")
m.addConstr(10*x1 - 8*x2 >= 0, "vitamin_c_constraint")
m.addConstr(14*x1 + x2 <= 67, "energy_stability_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of magnesium: {x1.x}")
    print(f"Milligrams of vitamin C: {x2.x}")
else:
    print("No optimal solution found")
