
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_magnesium", lb=-float('inf'), ub=float('inf'))
    x2 = model.addVar(name="milligrams_of_vitamin_C", lb=-float('inf'), ub=float('inf'), vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(7.49 * x1 + 3.26 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(14 * x1 + 1 * x2 >= 23)
    model.addConstr(10 * x1 - 8 * x2 >= 0)
    model.addConstr(14 * x1 + 1 * x2 <= 67)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of magnesium: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
