
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbohydrates = m.addVar(lb=0, name="carbohydrates")
vitamin_b9 = m.addVar(lb=0, name="vitamin_b9")
iron = m.addVar(lb=0, name="iron")
calcium = m.addVar(lb=0, name="calcium")
potassium = m.addVar(lb=0, name="potassium")
protein = m.addVar(lb=0, name="protein")


# Set objective function
m.setObjective(7.84*carbohydrates**2 + 6.33*vitamin_b9**2 + 8.31*vitamin_b9*calcium + 6.11*carbohydrates + 4.45*vitamin_b9 + 8.97*iron, gp.GRB.MAXIMIZE)

# Add constraints - Cognitive Performance Index
m.addConstr(12*carbohydrates + 4*potassium + 14*protein >= 16)
m.addConstr(12*carbohydrates**2 + 7*vitamin_b9**2 + 4*potassium**2 >= 16)
# ... (All other cognitive performance index constraints as derived in the JSON)

# Add constraints - Muscle Growth Index
m.addConstr(11 * carbohydrates + 8 * potassium >= 56)
m.addConstr(7 * iron + 10 * calcium >= 44)
# ... (All other muscle growth index constraints as derived in the JSON)


# Add resource constraints
m.addConstr(12*carbohydrates + 7*vitamin_b9 + 16*iron + 9*calcium + 4*potassium + 14*protein <= 194, "r0")  # Cognitive performance
m.addConstr(11*carbohydrates + 8*vitamin_b9 + 7*iron + 10*calcium + 8*potassium + 3*protein <= 346, "r1")  # Muscle growth


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Carbohydrates: %g' % carbohydrates.x)
    print('Vitamin B9: %g' % vitamin_b9.x)
    print('Iron: %g' % iron.x)
    print('Calcium: %g' % calcium.x)
    print('Potassium: %g' % potassium.x)
    print('Protein: %g' % protein.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

