
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(lb=-gp.GRB.INFINITY, name="x0")  # grams of carbohydrates
x1 = m.addVar(lb=-gp.GRB.INFINITY, name="x1")  # milligrams of vitamin B9
x2 = m.addVar(lb=-gp.GRB.INFINITY, name="x2")  # milligrams of iron
x3 = m.addVar(lb=-gp.GRB.INFINITY, name="x3")  # milligrams of calcium
x4 = m.addVar(lb=-gp.GRB.INFINITY, name="x4")  # milligrams of potassium
x5 = m.addVar(lb=-gp.GRB.INFINITY, name="x5")  # grams of protein

# Objective function
m.setObjective(7.84*x0**2 + 6.33*x1**2 + 8.31*x1*x3 + 6.11*x0 + 4.45*x1 + 8.97*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(12*x0 <= 194)
m.addConstr(11*x0 <= 346)
m.addConstr(7*x1 <= 194)
m.addConstr(8*x1 <= 346)
m.addConstr(16*x2 <= 194)
m.addConstr(7*x2 <= 346)
m.addConstr(9*x3 <= 194)
m.addConstr(10*x3 <= 346)
m.addConstr(4*x4 <= 194)
m.addConstr(8*x4 <= 346)
m.addConstr(14*x5 <= 194)
m.addConstr(3*x5 <= 346)
m.addConstr(12*x0 + 4*x4 + 14*x5 >= 16)
m.addConstr(12*x0**2 + 7*x1**2 + 4*x4**2 >= 16)
m.addConstr(11*x1 + 7*x2 + 9*x3 >= 16)
m.addConstr(7*x1**2 + 9*x3**2 + 14*x5**2 >= 16)
m.addConstr(12*x0 + 7*x2 + 9*x3 >= 16)
m.addConstr(12*x0 + 7*x2 + 14*x5 >= 16)
m.addConstr(7*x1 + 4*x4 + 14*x5 >= 16)
m.addConstr(12*x0**2 + 9*x3**2 + 4*x4**2 >= 16)
m.addConstr(12*x0 + 7*x2 + 9*x3 >= 16)
m.addConstr(7*x2**2 + 9*x3**2 + 4*x4**2 >= 16)
m.addConstr(7*x1**2 + 7*x2**2 + 14*x5**2 >= 16)
m.addConstr(7*x1 + 7*x2 + 4*x4 >= 16)
m.addConstr(7*x2**2 + 9*x3**2 + 14*x5**2 >= 16)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("The model is infeasible or unbounded.")
