
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")


# Set objective function
m.setObjective(1.24 * vitamin_a + 3.7 * vitamin_c + 2.15 * potassium + 5.04 * vitamin_b4 + 1.77 * vitamin_b3 + 9.43 * vitamin_b5, gp.GRB.MINIMIZE)

# Add constraints

# Cardiovascular support index constraints (simplified and deduplicated)
m.addConstr(13 * vitamin_a + 8 * vitamin_c + 8 * vitamin_b4 >= 16)
m.addConstr(8 * vitamin_c + 8 * vitamin_b4 + 4 * vitamin_b3 >= 16)
m.addConstr(10 * potassium + 8 * vitamin_b4 + 9 * vitamin_b5 >= 16)
m.addConstr(13 * vitamin_a + 10 * potassium + 9 * vitamin_b5 >= 16)
m.addConstr(8 * vitamin_b4 + 4 * vitamin_b3 + 9 * vitamin_b5 >= 16)
m.addConstr(13 * vitamin_a + 8 * vitamin_c + 9 * vitamin_b5 >= 16)
m.addConstr(13 * vitamin_a + 8 * vitamin_b4 + 9 * vitamin_b5 >= 16)
m.addConstr(13 * vitamin_a + 8 * vitamin_c + 10 * potassium >= 16)
m.addConstr(13 * vitamin_a + 8 * vitamin_b4 + 4 * vitamin_b3 >= 16)
m.addConstr(10 * potassium + 4 * vitamin_b3 + 9 * vitamin_b5 >= 16)
m.addConstr(8 * vitamin_c + 4 * vitamin_b3 + 9 * vitamin_b5 >= 16)
m.addConstr(8 * vitamin_c + 10 * potassium + 4 * vitamin_b3 >= 16)


# Digestive support index constraints (simplified and deduplicated)
m.addConstr(10 * vitamin_a + 14 * vitamin_c >= 18)
m.addConstr(8 * potassium + 11 * vitamin_b4 >= 42)
m.addConstr(10 * vitamin_a + 8 * vitamin_b3 >= 48)
m.addConstr(8 * potassium + 8 * vitamin_b3 >= 23)
m.addConstr(14 * vitamin_c + 8 * potassium >= 55)
m.addConstr(8 * vitamin_b3 + 10 * vitamin_b5 >= 41)
m.addConstr(11 * vitamin_b4 + 10 * vitamin_b5 >= 31)
m.addConstr(14 * vitamin_c + 11 * vitamin_b4 >= 52)
m.addConstr(14 * vitamin_c + 8 * vitamin_b3 >= 54)
m.addConstr(10 * vitamin_a + 11 * vitamin_b4 >= 34)
m.addConstr(11 * vitamin_b4 + 8 * vitamin_b3 + 10 * vitamin_b5 >= 50)
m.addConstr(10 * vitamin_a + 11 * vitamin_b4 + 10 * vitamin_b5 >= 50)
m.addConstr(10 * vitamin_a + 14 * vitamin_c + 8 * potassium + 11 * vitamin_b4 + 8 * vitamin_b3 + 10 * vitamin_b5 >= 50)

# Other constraints
m.addConstr(2 * vitamin_b4 - 10 * vitamin_b5 >= 0)
m.addConstr(-6 * vitamin_b4 + 6 * vitamin_b3 >= 0)
m.addConstr(4 * vitamin_b3 + 9 * vitamin_b5 <= 120)
m.addConstr(8 * vitamin_b4 + 9 * vitamin_b5 <= 102)
m.addConstr(13 * vitamin_a + 4 * vitamin_b3 <= 100)
m.addConstr(10 * potassium + 4 * vitamin_b3 + 9 * vitamin_b5 <= 38)
m.addConstr(13 * vitamin_a + 8 * vitamin_c + 9 * vitamin_b5 <= 71)
m.addConstr(8 * vitamin_c + 8 * vitamin_b4 + 9 * vitamin_b5 <= 48)
m.addConstr(13 * vitamin_a + 10 * potassium + 9 * vitamin_b5 <= 23)
m.addConstr(13 * vitamin_a + 8 * vitamin_c + 4 * vitamin_b3 <= 46)
m.addConstr(13 * vitamin_a + 10 * potassium + 4 * vitamin_b3 <= 81)
m.addConstr(8 * vitamin_c + 8 * vitamin_b4 + 4 * vitamin_b3 <= 113)
m.addConstr(13 * vitamin_a + 8 * vitamin_c + 8 * vitamin_b4 <= 128)
m.addConstr(13 * vitamin_a + 8 * vitamin_b4 + 9 * vitamin_b5 <= 119)
m.addConstr(13 * vitamin_a + 8 * vitamin_b4 + 4 * vitamin_b3 <= 22)
m.addConstr(13 * vitamin_a + 8 * vitamin_c + 10 * potassium <= 103)
m.addConstr(8 * vitamin_c + 10 * potassium + 9 * vitamin_b5 <= 116)
m.addConstr(10 * potassium + 8 * vitamin_b4 + 4 * vitamin_b3 <= 53)
m.addConstr(13 * vitamin_a + 10 * potassium + 8 * vitamin_b4 <= 114)
m.addConstr(13 * vitamin_a + 4 * vitamin_b3 + 9 * vitamin_b5 <= 109)
m.addConstr(8 * vitamin_c + 10 * potassium + 8 * vitamin_b4 <= 67)
m.addConstr(10 * vitamin_a + 8 * potassium + 11 * vitamin_b4 <= 87)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

