
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
network_admins = m.addVar(vtype=gp.GRB.INTEGER, name="network_admins")

# Set objective function
m.setObjective(9.23*pen_testers**2 + 6.65*pen_testers*network_admins + 8.65*security_onions**2 + 3.85*security_onions*network_admins + 2.11*network_admins**2 + 2.97*pen_testers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*pen_testers + 4*security_onions + 5*network_admins <= 44, "network_integrity_impact")
m.addConstr(7*pen_testers + 8*security_onions + 4*network_admins <= 53, "available_bandwidth_impact")
m.addConstr(5*pen_testers + 1*security_onions + 4*network_admins <= 49, "power_consumption")
m.addConstr(1*pen_testers + 1*security_onions + 4*network_admins <= 68, "dollar_cost")
m.addConstr(7*pen_testers**2 + 8*security_onions**2 >= 15, "min_bandwidth_squared")
m.addConstr(1*security_onions**2 + 4*network_admins**2 >= 16, "min_power_squared")
m.addConstr(5*pen_testers + 1*security_onions >= 15, "min_power_consumption")
m.addConstr(1*security_onions + 4*network_admins >= 7, "min_dollar_cost")
m.addConstr(6*pen_testers**2 - network_admins**2 >= 0, "squared_constraint")
m.addConstr(3*pen_testers + 5*network_admins <= 38, "combined_network_integrity1")
m.addConstr(3*pen_testers + 4*security_onions <= 39, "combined_network_integrity2")
m.addConstr(3*pen_testers + 4*security_onions + 5*network_admins <= 39, "combined_network_integrity3")
m.addConstr(7*pen_testers**2 + 8*security_onions**2 <= 46, "max_bandwidth_squared")
m.addConstr(7*pen_testers + 8*security_onions + 4*network_admins <= 46, "max_available_bandwidth")
m.addConstr(5*pen_testers**2 + 1*security_onions**2 <= 44, "max_power_consumption_squared1")
m.addConstr(1*security_onions**2 + 4*network_admins**2 <= 17, "max_power_consumption_squared2")
m.addConstr(5*pen_testers + 1*security_onions + 4*network_admins <= 17, "max_power_consumption")
m.addConstr(1*pen_testers**2 + 1*security_onions**2 <= 27, "max_dollar_cost_squared1")
m.addConstr(1*security_onions**2 + 4*network_admins**2 <= 32, "max_dollar_cost_squared2")
m.addConstr(1*pen_testers**2 + 1*security_onions**2 + 4*network_admins**2 <= 67, "max_dollar_cost_squared3")
m.addConstr(1*pen_testers + 1*security_onions + 4*network_admins <= 67, "max_dollar_cost")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pen_testers:', pen_testers.x)
    print('security_onions:', security_onions.x)
    print('network_admins:', network_admins.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

