
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='pen_testers', vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name='security_onions', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='network_administrators', vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(9.23*x0**2 + 6.65*x0*x2 + 8.65*x1**2 + 3.85*x1*x2 + 2.11*x2**2 + 2.97*x0, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 4*x1 + 5*x2 <= 44)
m.addConstr(7*x0 + 8*x1 + 4*x2 <= 53)
m.addConstr(5*x0 + x1 + 4*x2 <= 49)
m.addConstr(x0 + x1 + 4*x2 <= 68)
m.addConstr(x0**2 + x1**2 >= 15)
m.addConstr(x1**2 + x2**2 >= 16)
m.addConstr(5*x0 + x1 + 4*x2 >= 15)
m.addConstr(x1 + 4*x2 >= 7)
m.addConstr(6*x0**2 - x2**2 >= 0)
m.addConstr(3*x0 + 5*x2 <= 38)
m.addConstr(3*x0 + 4*x1 <= 39)
m.addConstr(3*x0 + 4*x1 + 5*x2 <= 39)
m.addConstr(x0**2 + x1**2 <= 46)
m.addConstr(7*x0 + 8*x1 + 4*x2 <= 46)
m.addConstr(5*x0**2 + x1**2 <= 44)
m.addConstr(x1**2 + 4*x2**2 <= 17)
m.addConstr(5*x0 + x1 + 4*x2 <= 17)
m.addConstr(x0**2 + x1**2 <= 27)
m.addConstr(x1**2 + 4*x2**2 <= 32)
m.addConstr(x0**2 + x1**2 + 4*x2**2 <= 67)
m.addConstr(x0 + x1 + 4*x2 <= 67)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('pen testers: ', x0.varValue)
    print('security onions: ', x1.varValue)
    print('network administrators: ', x2.varValue)
else:
    print('No solution found')
