
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    x = {}
    x[0] = m.addVar(vtype=gp.GRB.INTEGER, name="rotisserie_chickens")
    x[1] = m.addVar(vtype=gp.GRB.INTEGER, name="pickles")
    x[2] = m.addVar(vtype=gp.GRB.CONTINUOUS, name="apples")
    x[3] = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein_bars")


    # Set objective function
    m.setObjective(6.22*x[0] + 5.78*x[1] + 6.84*x[2] + 4.41*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*x[0] + 5*x[1] + 4*x[2] + 11*x[3] <= 116, "protein_limit")
    m.addConstr(9*x[0] + 5*x[1] + 3*x[2] + 2*x[3] <= 83, "fat_limit")
    m.addConstr(5*x[1] + 4*x[2] >= 24, "c1")
    m.addConstr(8*x[0] + 5*x[1] + 4*x[2] >= 27, "c2")
    m.addConstr(5*x[1] + 4*x[2] + 11*x[3] >= 27, "c3")
    m.addConstr(8*x[0] + 4*x[2] + 11*x[3] >= 27, "c4")
    m.addConstr(8*x[0] + 5*x[1] + 4*x[2] >= 16, "c5")
    m.addConstr(5*x[1] + 4*x[2] + 11*x[3] >= 16, "c6")
    m.addConstr(8*x[0] + 4*x[2] + 11*x[3] >= 16, "c7")
    m.addConstr(8*x[0] + 5*x[1] + 4*x[2] >= 16, "c8")
    m.addConstr(5*x[1] + 4*x[2] + 11*x[3] >= 16, "c9")
    m.addConstr(8*x[0] + 4*x[2] + 11*x[3] >= 16, "c10")
    m.addConstr(5*x[1] + 3*x[2] >= 18, "c11")
    m.addConstr(5*x[1] + 2*x[3] >= 6, "c12")
    m.addConstr(5*x[1] + 11*x[3] <= 72, "c13")
    m.addConstr(5*x[1] + 4*x[2] <= 49, "c14")
    m.addConstr(4*x[2] + 11*x[3] <= 35, "c15")
    m.addConstr(8*x[0] + 4*x[2] + 11*x[3] <= 31, "c16")
    m.addConstr(5*x[1] + 4*x[2] + 11*x[3] <= 113, "c17")
    m.addConstr(8*x[0] + 5*x[1] + 4*x[2] + 11*x[3] <= 113, "c18")
    m.addConstr(9*x[0] + 2*x[3] <= 44, "c19")
    m.addConstr(9*x[0] + 5*x[1] <= 71, "c20")
    m.addConstr(9*x[0] + 3*x[2] <= 45, "c21")
    m.addConstr(5*x[1] + 3*x[2] <= 79, "c22")
    m.addConstr(5*x[1] + 2*x[3] <= 49, "c23")
    m.addConstr(5*x[1] + 3*x[2] + 2*x[3] <= 68, "c24")
    m.addConstr(9*x[0] + 5*x[1] + 3*x[2] + 2*x[3] <= 68, "c25")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName} = {v.x}')
        print(f'Obj: {m.objVal}')

    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print(f'Optimization ended with status {m.status}')


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
