
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
ramen = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ramen")
black_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="black_beans")

# Set objective function
m.setObjective(4.31 * potatoes + 8.98 * ham_sandwiches + 5.94 * ramen + 6.61 * black_beans, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * ham_sandwiches + 14 * black_beans >= 48)
m.addConstr(18 * potatoes + 28 * ramen >= 20)
m.addConstr(18 * potatoes + 13 * ham_sandwiches >= 43)
m.addConstr(13 * ham_sandwiches + 28 * ramen >= 23)
m.addConstr(18 * potatoes + 13 * ham_sandwiches + 28 * ramen + 14 * black_beans >= 23)
m.addConstr(11 * potatoes + 15 * black_beans >= 44)
m.addConstr(8 * ham_sandwiches + 15 * black_beans >= 41)
m.addConstr(11 * potatoes + 8 * ham_sandwiches >= 32)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 29 * ramen >= 31)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 15 * black_beans >= 31)
m.addConstr(8 * ham_sandwiches + 29 * ramen + 15 * black_beans >= 31)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 29 * ramen >= 44)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 15 * black_beans >= 44)
m.addConstr(8 * ham_sandwiches + 29 * ramen + 15 * black_beans >= 44)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 29 * ramen >= 49)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 15 * black_beans >= 49)
m.addConstr(8 * ham_sandwiches + 29 * ramen + 15 * black_beans >= 49)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 29 * ramen + 15 * black_beans >= 49)
m.addConstr(-5 * ramen + 8 * black_beans >= 0)
m.addConstr(18 * potatoes + 28 * ramen + 14 * black_beans <= 160)
m.addConstr(18 * potatoes + 13 * ham_sandwiches + 28 * ramen <= 140)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 15 * black_beans <= 147)
m.addConstr(11 * potatoes + 29 * ramen + 15 * black_beans <= 198)

m.addConstr(18 * potatoes + 13 * ham_sandwiches + 28 * ramen + 14 * black_beans <= 218)
m.addConstr(11 * potatoes + 8 * ham_sandwiches + 29 * ramen + 15 * black_beans <= 218)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

