
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # potatoes
    x1 = model.addVar(name="x1", lb=0)  # ham sandwiches
    x2 = model.addVar(name="x2", lb=0)  # bowls of instant ramen
    x3 = model.addVar(name="x3", lb=0)  # black beans

    # Define the objective function
    model.setObjective(4.31 * x0 + 8.98 * x1 + 5.94 * x2 + 6.61 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(13 * x1 + 14 * x3 >= 48)
    model.addConstr(18 * x0 + 28 * x2 >= 20)
    model.addConstr(18 * x0 + 13 * x1 >= 43)
    model.addConstr(13 * x1 + 28 * x2 >= 23)
    model.addConstr(18 * x0 + 13 * x1 + 28 * x2 + 14 * x3 >= 23)
    model.addConstr(11 * x0 + 15 * x3 >= 44)
    model.addConstr(8 * x1 + 15 * x3 >= 41)
    model.addConstr(11 * x0 + 8 * x1 >= 32)
    model.addConstr(11 * x0 + 8 * x1 + 29 * x2 >= 31)
    model.addConstr(11 * x0 + 8 * x1 + 15 * x3 >= 31)
    model.addConstr(8 * x1 + 29 * x2 + 15 * x3 >= 31)
    model.addConstr(11 * x0 + 8 * x1 + 29 * x2 >= 44)
    model.addConstr(11 * x0 + 8 * x1 + 15 * x3 >= 44)
    model.addConstr(8 * x1 + 29 * x2 + 15 * x3 >= 44)
    model.addConstr(11 * x0 + 8 * x1 + 29 * x2 >= 49)
    model.addConstr(11 * x0 + 8 * x1 + 15 * x3 >= 49)
    model.addConstr(8 * x1 + 29 * x2 + 15 * x3 >= 49)
    model.addConstr(11 * x0 + 8 * x1 + 29 * x2 + 15 * x3 >= 49)
    model.addConstr(-5 * x2 + 8 * x3 >= 0)
    model.addConstr(18 * x0 + 28 * x2 + 14 * x3 <= 160)
    model.addConstr(18 * x0 + 13 * x1 + 28 * x2 <= 140)
    model.addConstr(11 * x0 + 8 * x1 + 15 * x3 <= 147)
    model.addConstr(11 * x0 + 29 * x2 + 15 * x3 <= 198)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Potatoes: ", x0.varValue)
        print("Ham sandwiches: ", x1.varValue)
        print("Bowls of instant ramen: ", x2.varValue)
        print("Black beans: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
