
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
black_pens = m.addVar(vtype=gp.GRB.INTEGER, name="black_pens")
cafeteria_chairs = m.addVar(vtype=gp.GRB.INTEGER, name="cafeteria_chairs")
staplers = m.addVar(vtype=gp.GRB.INTEGER, name="staplers")


# Set objective function
m.setObjective(8 * black_pens + 9 * cafeteria_chairs + 5 * staplers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * black_pens + 18 * cafeteria_chairs >= 29, "c1")
m.addConstr(16 * black_pens + 18 * cafeteria_chairs + 11 * staplers >= 29, "c2")
m.addConstr(-10 * black_pens + 4 * staplers >= 0, "c3")
m.addConstr(-1 * cafeteria_chairs + 5 * staplers >= 0, "c4")
m.addConstr(10 * black_pens - 4 * cafeteria_chairs >= 0, "c5")
m.addConstr(16 * black_pens + 11 * staplers <= 82, "c6")
m.addConstr(18 * cafeteria_chairs + 11 * staplers <= 72, "c7")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('black_pens:', black_pens.x)
    print('cafeteria_chairs:', cafeteria_chairs.x)
    print('staplers:', staplers.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

