
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="black_pens")
x2 = m.addVar(vtype=GRB.INTEGER, name="cafeteria_chairs")
x3 = m.addVar(vtype=GRB.INTEGER, name="staplers")

# Set the objective function
m.setObjective(8*x1 + 9*x2 + 5*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x1 + 18*x2 >= 29, "usefulness_rating_bc")
m.addConstr(16*x1 + 18*x2 + 11*x3 >= 29, "total_usefulness_rating")
m.addConstr(-10*x1 + 4*x3 >= 0, "black_pens_staplers")
m.addConstr(-x2 + 5*x3 >= 0, "cafeteria_chairs_staplers")
m.addConstr(10*x1 - 4*x2 >= 0, "black_pens_cafeteria_chairs")
m.addConstr(16*x1 + 11*x3 <= 82, "usefulness_rating_bs")
m.addConstr(18*x2 + 11*x3 <= 72, "usefulness_rating_cs")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Black Pens: {x1.x}")
    print(f"Cafeteria Chairs: {x2.x}")
    print(f"Staplers: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
