
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='black_pens', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='cafeteria_chairs', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='staplers', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(8*x1 + 9*x2 + 5*x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(16*x1 + 18*x2 >= 29)
    model.addConstr(16*x1 + 18*x2 + 11*x3 >= 29)
    model.addConstr(-10*x1 + 4*x3 >= 0)
    model.addConstr(-x2 + 5*x3 >= 0)
    model.addConstr(10*x1 - 4*x2 >= 0)
    model.addConstr(16*x1 + 11*x3 <= 82)
    model.addConstr(18*x2 + 11*x3 <= 72)

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Black pens: ', x1.varValue)
        print('Cafeteria chairs: ', x2.varValue)
        print('Staplers: ', x3.varValue)
    else:
        print('The model is infeasible')

optimize_problem()
