
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
roses = m.addVar(vtype=gp.GRB.INTEGER, name="roses")
chili_plants = m.addVar(vtype=gp.GRB.INTEGER, name="chili_plants")
chrysanthemums = m.addVar(vtype=gp.GRB.INTEGER, name="chrysanthemums")
pansies = m.addVar(vtype=gp.GRB.INTEGER, name="pansies")
tomato_vines = m.addVar(vtype=gp.GRB.INTEGER, name="tomato_vines")


# Set objective function
m.setObjective(6.17 * roses + 2.7 * chili_plants + 5.24 * chrysanthemums + 9.67 * pansies + 1.02 * tomato_vines, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * roses + 2 * pansies >= 22)
m.addConstr(17 * chili_plants + 2 * pansies >= 21)
m.addConstr(14 * roses + 11 * tomato_vines >= 26)
m.addConstr(14 * roses + 17 * chili_plants >= 12)
m.addConstr(14 * roses + 13 * chrysanthemums >= 13)
m.addConstr(14 * roses + 17 * chili_plants + 13 * chrysanthemums + 2 * pansies + 11 * tomato_vines >= 13)
m.addConstr(11 * chili_plants + 4 * tomato_vines >= 41)
m.addConstr(2 * roses + 7 * pansies >= 39)
m.addConstr(2 * roses + 11 * chili_plants >= 23)
m.addConstr(11 * chili_plants + 17 * chrysanthemums >= 39)
m.addConstr(11 * chili_plants + 7 * pansies >= 49)
m.addConstr(2 * roses + 4 * tomato_vines >= 33)
m.addConstr(17 * chrysanthemums + 7 * pansies >= 20)
m.addConstr(7 * pansies + 4 * tomato_vines >= 38)

# ... (add all remaining constraints similarly)


m.addConstr(8 * chili_plants - 3 * pansies >= 0)
m.addConstr(10 * chrysanthemums - 9 * pansies >= 0)
m.addConstr(13 * chrysanthemums + 2 * pansies <= 65)
m.addConstr(13 * chrysanthemums + 11 * tomato_vines <= 89)
m.addConstr(17 * chili_plants + 13 * chrysanthemums <= 41)
m.addConstr(17 * chili_plants + 2 * pansies <= 35)
m.addConstr(14 * roses + 17 * chili_plants <= 97)
m.addConstr(17 * chili_plants + 11 * tomato_vines <= 32)
m.addConstr(2 * roses + 11 * chili_plants + 17 * chrysanthemums <= 51)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

