
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="roses", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="chili_plants", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name="chrysanthemums", vtype=gurobi.GRB.INTEGER)
x4 = model.addVar(name="pansies", vtype=gurobi.GRB.INTEGER)
x5 = model.addVar(name="tomato_vines", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(6.17 * x1 + 2.7 * x2 + 5.24 * x3 + 9.67 * x4 + 1.02 * x5, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(14 * x1 + 2 * x4 >= 22)
model.addConstr(17 * x2 + 2 * x4 >= 21)
model.addConstr(14 * x1 + 11 * x5 >= 26)
model.addConstr(14 * x1 + 17 * x2 >= 12)
model.addConstr(14 * x1 + 13 * x3 >= 13)
model.addConstr(14 * x1 + 17 * x2 + 13 * x3 + 2 * x4 + 11 * x5 >= 13)
model.addConstr(11 * x2 + 4 * x5 >= 41)
model.addConstr(2 * x1 + 7 * x4 >= 39)
model.addConstr(2 * x1 + 11 * x2 >= 23)
model.addConstr(11 * x2 + 17 * x3 >= 39)
model.addConstr(11 * x2 + 7 * x4 >= 49)
model.addConstr(2 * x1 + 4 * x5 >= 33)
model.addConstr(17 * x3 + 7 * x4 >= 20)
model.addConstr(7 * x4 + 4 * x5 >= 38)
model.addConstr(11 * x2 + 17 * x3 + 7 * x4 >= 38)
model.addConstr(11 * x2 + 17 * x3 + 4 * x5 >= 38)
model.addConstr(2 * x1 + 11 * x2 + 17 * x3 >= 38)
model.addConstr(17 * x3 + 7 * x4 + 4 * x5 >= 38)
model.addConstr(2 * x1 + 17 * x3 + 4 * x5 >= 38)
model.addConstr(2 * x1 + 17 * x3 + 7 * x4 >= 38)
model.addConstr(2 * x1 + 11 * x2 + 7 * x4 >= 38)
model.addConstr(11 * x2 + 17 * x3 + 4 * x5 >= 45)
model.addConstr(11 * x2 + 17 * x3 + 7 * x4 >= 45)
model.addConstr(2 * x1 + 11 * x2 + 17 * x3 >= 45)
model.addConstr(17 * x3 + 7 * x4 + 4 * x5 >= 45)
model.addConstr(2 * x1 + 17 * x3 + 4 * x5 >= 45)
model.addConstr(2 * x1 + 17 * x3 + 7 * x4 >= 45)
model.addConstr(2 * x1 + 11 * x2 + 7 * x4 >= 45)
model.addConstr(11 * x2 + 17 * x3 + 7 * x4 >= 41)
model.addConstr(11 * x2 + 17 * x3 + 4 * x5 >= 41)
model.addConstr(2 * x1 + 11 * x2 + 17 * x3 >= 41)
model.addConstr(17 * x3 + 7 * x4 + 4 * x5 >= 41)
model.addConstr(2 * x1 + 17 * x3 + 4 * x5 >= 41)
model.addConstr(2 * x1 + 17 * x3 + 7 * x4 >= 41)
model.addConstr(2 * x1 + 11 * x2 + 7 * x4 >= 41)
model.addConstr(8 * x2 - 3 * x4 >= 0)
model.addConstr(10 * x3 - 9 * x4 >= 0)
model.addConstr(13 * x3 + 2 * x4 <= 65)
model.addConstr(13 * x3 + 11 * x5 <= 89)
model.addConstr(17 * x2 + 13 * x3 <= 41)
model.addConstr(17 * x2 + 2 * x4 <= 35)
model.addConstr(14 * x1 + 17 * x2 <= 97)
model.addConstr(17 * x2 + 11 * x5 <= 32)
model.addConstr(2 * x1 + 11 * x2 + 17 * x3 <= 51)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Roses: ", x1.varValue)
    print("Chili Plants: ", x2.varValue)
    print("Chrysanthemums: ", x3.varValue)
    print("Pansies: ", x4.varValue)
    print("Tomato Vines: ", x5.varValue)
else:
    print("The model is infeasible")
