
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Paul", "Peggy", "Jean", "Dale"])


    # Set objective function
    m.setObjective(6*x[0] + 3*x[1] + 2*x[2] + 6*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(21*x[0] + 21*x[2] >= 33)
    m.addConstr(21*x[0] + 16*x[1] >= 38)
    m.addConstr(16*x[1] + 21*x[2] >= 33)
    m.addConstr(16*x[1] + 21*x[2] + 17*x[3] >= 50)
    m.addConstr(21*x[0] + 21*x[2] + 17*x[3] >= 50)
    m.addConstr(16*x[1] + 21*x[2] + 17*x[3] >= 50)
    m.addConstr(21*x[0] + 21*x[2] + 17*x[3] >= 50)
    m.addConstr(x[1] + 14*x[2] >= 39)
    m.addConstr(21*x[2] + 17*x[3] <= 103)
    m.addConstr(16*x[1] + 21*x[2] <= 119)
    m.addConstr(16*x[1] + 17*x[3] <= 87)
    m.addConstr(21*x[0] + 21*x[2] + 17*x[3] <= 53)
    m.addConstr(21*x[0] + 16*x[1] + 21*x[2] + 17*x[3] <= 53)
    m.addConstr(x[1] + 14*x[2] <= 243)
    m.addConstr(x[0] + 19*x[3] <= 222)
    m.addConstr(x[0] + x[1] <= 194)
    m.addConstr(x[0] + 14*x[2] <= 193)
    m.addConstr(14*x[2] + 19*x[3] <= 71)
    m.addConstr(x[1] + 14*x[2] + 19*x[3] <= 94)
    m.addConstr(x[0] + x[1] + 14*x[2] + 19*x[3] <= 94)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
