
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Paul
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Peggy
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Jean
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Dale

    # Objective function
    model.setObjective(6*x0 + 3*x1 + 2*x2 + 6*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(21*x0 + 21*x2 >= 33)
    model.addConstr(21*x0 + 16*x1 >= 38)
    model.addConstr(16*x1 + 21*x2 >= 33)
    model.addConstr(16*x1 + 21*x2 + 17*x3 >= 50)
    model.addConstr(21*x0 + 21*x2 + 17*x3 >= 50)
    model.addConstr(17*x2 + 17*x3 <= 103)
    model.addConstr(16*x1 + 21*x2 <= 119)
    model.addConstr(16*x1 + 17*x3 <= 87)
    model.addConstr(21*x0 + 21*x2 + 17*x3 <= 53)
    model.addConstr(21*x0 + 16*x1 + 21*x2 + 17*x3 <= 53)
    model.addConstr(x1 + 14*x2 <= 243)
    model.addConstr(x0 + 19*x3 <= 222)
    model.addConstr(x0 + x1 <= 194)
    model.addConstr(x0 + 14*x2 <= 193)
    model.addConstr(14*x2 + 19*x3 <= 71)
    model.addConstr(x1 + 14*x2 + 19*x3 <= 94)
    model.addConstr(x0 + x1 + 14*x2 + 19*x3 <= 94)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Paul: ", x0.varValue)
        print("Hours worked by Peggy: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
        print("Hours worked by Dale: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
