
import gurobipy as gp

# Create a new model
m = gp.Model("work_optimization")

# Create variables
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="John")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")


# Set objective function
m.setObjective(3.83 * bill + 3.16 * bobby + 8.09 * dale + 9.17 * john + 5.23 * jean + 9.23 * peggy, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * bill + 23 * jean >= 69)
m.addConstr(8 * bobby + 23 * jean >= 70)
m.addConstr(23 * jean + 17 * peggy >= 57)
m.addConstr(8 * bobby + 5 * john >= 74)
m.addConstr(22 * bill + 5 * john >= 70)
m.addConstr(8 * bobby + 1 * dale >= 62)
m.addConstr(22 * bill + 1 * dale >= 35)
m.addConstr(1 * dale + 5 * john >= 47)

# ... (add remaining constraints similarly)

m.addConstr(4 * bobby - 2 * peggy >= 0)
m.addConstr(5 * john + 23 * jean <= 190)
m.addConstr(1 * dale + 5 * john <= 245)
m.addConstr(22 * bill + 23 * jean <= 112)
m.addConstr(8 * bobby + 23 * jean <= 81)
m.addConstr(22 * bill + 5 * john <= 135)
m.addConstr(1 * dale + 23 * jean <= 428)
m.addConstr(22 * bill + 8 * bobby + 23 * jean <= 419)
m.addConstr(8 * bobby + 1 * dale + 23 * jean <= 365)
m.addConstr(22 * bill + 23 * jean + 17 * peggy <= 305)
m.addConstr(22 * bill + 1 * dale + 17 * peggy <= 378)
m.addConstr(22 * bill + 8 * bobby + 5 * john <= 371)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

