
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="SOC_operators")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")

    # Set objective function
    model.setObjective(1*x0 + 6*x1 + 8*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15*x0 + 24*x1 + 21*x2 <= 132, "c0")
    model.addConstr(21*x0 + 22*x1 + 7*x2 <= 198, "c1")
    model.addConstr(16*x0 + 8*x1 + 2*x2 <= 128, "c2")
    model.addConstr(16*x0 + 24*x1 + 24*x2 <= 155, "c3")
    model.addConstr(21*x0 + 24*x1 + 9*x2 <= 92, "c4")
    model.addConstr(15*x0 + 21*x2 >= 27, "c5")
    model.addConstr(24*x1 + 21*x2 >= 37, "c6")
    model.addConstr(15*x0 + 24*x1 + 21*x2 >= 22, "c7")
    model.addConstr(16*x0 + 24*x1 >= 37, "c8")
    model.addConstr(24*x1 + 24*x2 >= 22, "c9")
    model.addConstr(16*x0 + 24*x1 + 24*x2 >= 44, "c10")
    model.addConstr(21*x0 + 24*x1 + 9*x2 >= 23, "c11")
    model.addConstr(15*x0 + 24*x1 <= 132, "c12")
    model.addConstr(15*x0 + 21*x2 <= 59, "c13")
    model.addConstr(24*x1 + 21*x2 <= 110, "c14")
    model.addConstr(15*x0 + 24*x1 + 21*x2 <= 110, "c15")
    model.addConstr(22*x1 + 7*x2 <= 197, "c16")
    model.addConstr(21*x0 + 22*x1 <= 190, "c17")
    model.addConstr(21*x0 + 22*x1 + 7*x2 <= 66, "c18")
    model.addConstr(16*x0 + 24*x2 <= 147, "c19")
    model.addConstr(24*x1 + 24*x2 <= 140, "c20")
    model.addConstr(16*x0 + 24*x1 <= 53, "c21")
    model.addConstr(21*x0 + 9*x2 <= 81, "c22")
    model.addConstr(21*x0 + 24*x1 <= 69, "c23")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
