
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="SOC_operators", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="automatic_alerts", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="system_administrators", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(1*x0 + 6*x1 + 8*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x0 + 24*x1 + 21*x2 <= 132)
m.addConstr(21*x0 + 22*x1 + 7*x2 <= 198)
m.addConstr(16*x0 + 8*x1 + 2*x2 <= 128)
m.addConstr(16*x0 + 24*x1 + 24*x2 <= 155)
m.addConstr(21*x0 + 24*x1 + 9*x2 <= 92)
m.addConstr(15*x0 + 21*x2 >= 27)
m.addConstr(24*x1 + 21*x2 >= 37)
m.addConstr(15*x0 + 24*x1 + 21*x2 >= 22)
m.addConstr(16*x0 + 24*x1 >= 37)
m.addConstr(24*x1 + 24*x2 >= 22)
m.addConstr(16*x0 + 24*x1 + 24*x2 >= 44)
m.addConstr(21*x0 + 24*x1 + 9*x2 >= 23)
m.addConstr(15*x0 + 24*x1 + 21*x2 <= 110)
m.addConstr(15*x0 + 21*x2 <= 59)
m.addConstr(24*x1 + 21*x2 <= 110)
m.addConstr(21*x0 + 22*x1 + 7*x2 <= 197)
m.addConstr(21*x0 + 22*x1 <= 190)
m.addConstr(21*x0 + 22*x1 + 7*x2 <= 66)
m.addConstr(16*x0 + 24*x1 + 24*x2 <= 147)
m.addConstr(24*x1 + 24*x2 <= 140)
m.addConstr(16*x0 + 24*x1 <= 53)
m.addConstr(16*x0 + 24*x1 + 24*x2 <= 53)
m.addConstr(21*x0 + 9*x2 <= 81)
m.addConstr(21*x0 + 24*x1 <= 69)
m.addConstr(21*x0 + 24*x1 + 9*x2 <= 69)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("SOC operators: ", x0.varValue)
    print("automatic alerts: ", x1.varValue)
    print("system administrators: ", x2.varValue)
else:
    print("The model is infeasible")
