
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
foods = ['chicken drumsticks', 'pickles', 'hot dogs', 'potatoes', 'cantaloupes', 'granola bars', 'steaks']
x = m.addVars(range(len(foods)), vtype=GRB.INTEGER, name=foods)

# Set objective function
m.setObjective(7*x[0] + 3*x[1] + 8*x[2] + 5*x[3] + 9*x[4] + 1*x[5] + 9*x[6], GRB.MINIMIZE)

# Healthiness rating and cost data
healthiness = [8, 12, 20, 7, 5, 6, 11]
cost = [7, 19, 9, 8, 13, 13, 3]

# Add healthiness constraints
m.addConstr(8*x[0] + 12*x[1] + 20*x[2] + 7*x[3] + 5*x[4] + 6*x[5] + 11*x[6] <= 281)


# Add cost constraint
m.addConstr(7*x[0] + 19*x[1] + 9*x[2] + 8*x[3] + 13*x[4] + 13*x[5] + 3*x[6] <= 340)

# Add other constraints from JSON "constraints"
for constraint_str in json_data["constraints"]:
    m.addConstr(eval(constraint_str))  # eval converts string to expression


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal objective:', m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

