
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
ravioli = m.addVar(name="ravioli")
chicken_breasts = m.addVar(name="chicken_breasts")

# Set objective function
m.setObjective(7 * ravioli + 9 * chicken_breasts, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12 * ravioli + 17 * chicken_breasts >= 44, "iron_min")
m.addConstr(15 * ravioli + 14 * chicken_breasts >= 84, "fat_min")
m.addConstr(14 * ravioli + 9 * chicken_breasts >= 69, "healthiness_min")
m.addConstr(11 * ravioli + 2 * chicken_breasts >= 114, "cost_min")
m.addConstr(13 * ravioli + 11 * chicken_breasts >= 56, "protein_min")
m.addConstr(-9 * ravioli + 1 * chicken_breasts >= 0, "custom_constraint")

m.addConstr(12 * ravioli + 17 * chicken_breasts <= 96, "iron_max")
m.addConstr(15 * ravioli + 14 * chicken_breasts <= 126, "fat_max")
m.addConstr(14 * ravioli + 9 * chicken_breasts <= 124, "healthiness_max")
m.addConstr(11 * ravioli + 2 * chicken_breasts <= 188, "cost_max")
m.addConstr(13 * ravioli + 11 * chicken_breasts <= 98, "protein_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ravioli:', ravioli.x)
    print('chicken_breasts:', chicken_breasts.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

