
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="ravioli", lb=0, ub=None)  # ravioli
x2 = model.addVar(name="chicken_breasts", lb=0, ub=None)  # chicken breasts

# Define the objective function
model.setObjective(7 * x1 + 9 * x2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(12 * x1 + 17 * x2 >= 44, name="iron_constraint")
model.addConstr(15 * x1 + 14 * x2 >= 84, name="fat_constraint")
model.addConstr(14 * x1 + 9 * x2 >= 69, name="healthiness_rating_constraint")
model.addConstr(11 * x1 + 2 * x2 >= 114, name="cost_constraint")
model.addConstr(13 * x1 + 11 * x2 >= 56, name="protein_constraint")
model.addConstr(-9 * x1 + x2 >= 0, name="relationship_constraint")
model.addConstr(12 * x1 + 17 * x2 <= 96, name="iron_upper_bound")
model.addConstr(15 * x1 + 14 * x2 <= 126, name="fat_upper_bound")
model.addConstr(14 * x1 + 9 * x2 <= 124, name="healthiness_rating_upper_bound")
model.addConstr(11 * x1 + 2 * x2 <= 188, name="cost_upper_bound")
model.addConstr(13 * x1 + 11 * x2 <= 98, name="protein_upper_bound")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {x1.varValue}")
    print(f"Chicken Breasts: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
