
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")


# Set objective function
m.setObjective(6*potassium + 3*vitamin_a + 4*iron + 9*calcium, gp.GRB.MAXIMIZE)

# Add constraints

m.addConstr(2*potassium + 8*vitamin_a + 9*calcium >= 31, "digestive_support1")
m.addConstr(5*potassium + 13*calcium >= 31, "cognitive_performance1")
m.addConstr(5*potassium + 9*iron >= 40, "cognitive_performance2")
m.addConstr(9*iron + 13*calcium >= 27, "cognitive_performance3")
m.addConstr(5*potassium + 5*vitamin_a >= 18, "cognitive_performance4")
m.addConstr(7*potassium + 9*calcium >= 13, "immune_support1")
m.addConstr(7*potassium + 4*vitamin_a + 3*iron >= 29, "immune_support2")
m.addConstr(4*vitamin_a + 3*iron + 9*calcium >= 29, "immune_support3")
m.addConstr(7*potassium + 3*iron + 9*calcium >= 29, "immune_support4")
m.addConstr(7*potassium + 4*vitamin_a + 3*iron >= 24, "immune_support5")
m.addConstr(4*vitamin_a + 3*iron + 9*calcium >= 24, "immune_support6")
m.addConstr(7*potassium + 3*iron + 9*calcium >= 24, "immune_support7")


m.addConstr(2*potassium + 3*iron <= 53, "digestive_support2")
m.addConstr(2*potassium + 8*vitamin_a <= 173, "digestive_support3")
m.addConstr(8*vitamin_a + 3*iron <= 106, "digestive_support4")
m.addConstr(2*potassium + 9*calcium <= 135, "digestive_support5")
m.addConstr(3*iron + 9*calcium <= 52, "digestive_support6")
m.addConstr(2*potassium + 8*vitamin_a + 3*iron <= 59, "digestive_support7")
m.addConstr(2*potassium + 8*vitamin_a + 3*iron + 9*calcium <= 59, "digestive_support8")

m.addConstr(5*potassium + 9*iron <= 74, "cognitive_performance5")
m.addConstr(5*potassium + 13*calcium <= 163, "cognitive_performance6")
m.addConstr(5*potassium + 5*vitamin_a <= 84, "cognitive_performance7")
m.addConstr(9*iron + 13*calcium <= 60, "cognitive_performance8")
m.addConstr(5*potassium + 9*iron + 13*calcium <= 145, "cognitive_performance9")
m.addConstr(5*vitamin_a + 9*iron + 13*calcium <= 103, "cognitive_performance10")
m.addConstr(5*potassium + 5*vitamin_a + 9*iron <= 92, "cognitive_performance11")
m.addConstr(5*potassium + 5*vitamin_a + 9*iron + 13*calcium <= 92, "cognitive_performance12")

m.addConstr(7*potassium + 4*vitamin_a <= 143, "immune_support8")
m.addConstr(3*iron + 9*calcium <= 111, "immune_support9")
m.addConstr(7*potassium + 4*vitamin_a + 3*iron + 9*calcium <= 111, "immune_support10")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

