
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # milligrams of potassium
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin A
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of iron
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # milligrams of calcium

    # Objective function
    model.setObjective(6 * x0 + 3 * x1 + 4 * x2 + 9 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * x0 + 8 * x1 + 3 * x2 + 9 * x3 >= 31)
    model.addConstr(5 * x0 + 13 * x3 >= 31)
    model.addConstr(5 * x0 + 9 * x2 >= 40)
    model.addConstr(9 * x2 + 13 * x3 >= 27)
    model.addConstr(5 * x0 + 5 * x1 >= 18)
    model.addConstr(7 * x0 + 9 * x3 >= 13)
    model.addConstr(7 * x0 + 4 * x1 + 3 * x2 >= 29)
    model.addConstr(4 * x1 + 3 * x2 + 9 * x3 >= 29)
    model.addConstr(7 * x0 + 3 * x2 + 9 * x3 >= 29)
    model.addConstr(7 * x0 + 4 * x1 + 3 * x2 >= 29)
    model.addConstr(4 * x1 + 3 * x2 + 9 * x3 >= 29)
    model.addConstr(7 * x0 + 3 * x2 + 9 * x3 >= 29)
    model.addConstr(7 * x0 + 4 * x1 + 3 * x2 >= 24)
    model.addConstr(4 * x1 + 3 * x2 + 9 * x3 >= 24)
    model.addConstr(7 * x0 + 3 * x2 + 9 * x3 >= 24)
    model.addConstr(2 * x0 + 3 * x2 <= 53)
    model.addConstr(2 * x0 + 8 * x1 <= 173)
    model.addConstr(8 * x1 + 3 * x2 <= 106)
    model.addConstr(2 * x0 + 9 * x3 <= 135)
    model.addConstr(3 * x2 + 9 * x3 <= 52)
    model.addConstr(2 * x0 + 8 * x1 + 3 * x2 <= 59)
    model.addConstr(2 * x0 + 8 * x1 + 3 * x2 + 9 * x3 <= 59)
    model.addConstr(5 * x0 + 9 * x2 <= 74)
    model.addConstr(5 * x0 + 13 * x3 <= 163)
    model.addConstr(5 * x0 + 5 * x1 <= 84)
    model.addConstr(9 * x2 + 13 * x3 <= 60)
    model.addConstr(5 * x0 + 9 * x2 + 13 * x3 <= 145)
    model.addConstr(5 * x1 + 9 * x2 + 13 * x3 <= 103)
    model.addConstr(5 * x0 + 5 * x1 + 9 * x2 <= 92)
    model.addConstr(5 * x0 + 5 * x1 + 9 * x2 + 13 * x3 <= 92)
    model.addConstr(7 * x0 + 4 * x1 <= 143)
    model.addConstr(3 * x2 + 9 * x3 <= 111)
    model.addConstr(7 * x0 + 4 * x1 + 3 * x2 + 9 * x3 <= 111)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of potassium: {x0.varValue}")
        print(f"Milligrams of vitamin A: {x1.varValue}")
        print(f"Milligrams of iron: {x2.varValue}")
        print(f"Milligrams of calcium: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
