
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin E
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x1") # milligrams of vitamin B12
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x2") # milligrams of vitamin K


# Set objective function
m.setObjective(2*x0**2 + 9*x0*x1 + 7*x0*x2 + 2*x1**2 + 8*x1*x2 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x0**2 + x2**2 >= 39)
m.addConstr(19*x1 + x2 >= 71)
m.addConstr(17*x0 + 19*x1 + x2 >= 57)
m.addConstr(16*x1 + 3*x2 >= 32)
m.addConstr(23*x1 + 13*x2 >= 117)
m.addConstr(11*x0 + 13*x2 >= 49)
m.addConstr(14*x1**2 + 22*x2**2 <= 286)
m.addConstr(x0**2 + 22*x2**2 <= 119)
m.addConstr(x0 + 14*x1 <= 297)
m.addConstr(x0**2 + 14*x1**2 + 22*x2**2 <= 281)
m.addConstr(x0 + 14*x1 + 22*x2 <= 281)
m.addConstr(17*x0**2 + 19*x1**2 <= 159)
m.addConstr(17*x0 + x2 <= 169)
m.addConstr(17*x0 + 19*x1 + x2 <= 169)
m.addConstr(22*x0 + 3*x2 <= 241)
m.addConstr(22*x0 + 16*x1 + 3*x2 <= 241)
m.addConstr(11*x0**2 + 23*x1**2 <= 276)
m.addConstr(11*x0 + 23*x1 + 13*x2 <= 276)

# Resource constraints
m.addConstr(x0 + 14*x1 + 22*x2 <= 316)
m.addConstr(17*x0 + 19*x1 + x2 <= 305)
m.addConstr(22*x0 + 16*x1 + 3*x2 <= 258)
m.addConstr(11*x0 + 23*x1 + 13*x2 <= 390)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
    print('x2: %g' % x2.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
