
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Ringo
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1") # hours worked by Peggy
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="x2") # hours worked by Paul


    # Set objective function
    model.setObjective(2*x0 + 4*x1 + 7*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9*x0 + 3*x1 >= 132, "c1")
    model.addConstr(9*x0 + 3*x1 + 15*x2 >= 132, "c2")
    model.addConstr(11*x1 + 5*x2 >= 33, "c3")
    model.addConstr(1*x0 + 11*x1 >= 85, "c4")
    model.addConstr(1*x0 + 11*x1 + 5*x2 >= 85, "c5")
    model.addConstr(14*x0 + 2*x2 >= 110, "c6")
    model.addConstr(14*x0 + 15*x1 + 2*x2 >= 98, "c7")
    model.addConstr(-4*x0 + 9*x1 >= 0, "c8")
    model.addConstr(9*x0 + 15*x2 <= 179, "c9")
    model.addConstr(3*x1 + 15*x2 <= 304, "c10")
    model.addConstr(11*x1 + 5*x2 <= 232, "c11")

    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"x0 (hours worked by Ringo): {x0.x}")
        print(f"x1 (hours worked by Peggy): {x1.x}")
        print(f"x2 (hours worked by Paul): {x2.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized correctly.")

