
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Ringo", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="hours_worked_by_Peggy", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Paul", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(2*x0 + 4*x1 + 7*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x0 <= 407)
    model.addConstr(1*x0 <= 305)
    model.addConstr(14*x0 <= 423)
    model.addConstr(3*x1 <= 407)
    model.addConstr(11*x1 <= 305)
    model.addConstr(15*x1 <= 423)
    model.addConstr(15*x2 <= 407)
    model.addConstr(5*x2 <= 305)
    model.addConstr(2*x2 <= 423)
    model.addConstr(9*x0 + 3*x1 >= 132)
    model.addConstr(9*x0 + 3*x1 + 15*x2 >= 132)
    model.addConstr(11*x1 + 5*x2 >= 33)
    model.addConstr(1*x0 + 11*x1 >= 85)
    model.addConstr(1*x0 + 11*x1 + 5*x2 >= 85)
    model.addConstr(14*x0 + 2*x2 >= 110)
    model.addConstr(14*x0 + 15*x1 + 2*x2 >= 98)
    model.addConstr(-4*x0 + 9*x1 >= 0)
    model.addConstr(9*x0 + 15*x2 <= 179)
    model.addConstr(3*x1 + 15*x2 <= 304)
    model.addConstr(11*x1 + 5*x2 <= 232)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Ringo: {x0.varValue}")
        print(f"Hours worked by Peggy: {x1.varValue}")
        print(f"Hours worked by Paul: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
