
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin K
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B9
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # milligrams of vitamin B3
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin D


# Set objective function
m.setObjective(4*x0**2 + 6*x0*x1 + x0*x2 + 8*x0*x3 + x1**2 + 8*x1*x2 + 7*x1*x3 + 6*x2*x3 + 8*x3**2 + 5*x1 + 7*x2 + 4*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x0 + 5*x1 + 4*x2 + 3*x3 <= 478)
m.addConstr(15*x0 + 18*x1 + 29*x2 + 24*x3 <= 413)
m.addConstr(4*x2 + 3*x3 >= 96)
m.addConstr(17*x0 + 5*x1 >= 91)
m.addConstr(17*x0**2 + 3*x3**2 >= 105)
m.addConstr(5*x1 + 4*x2 >= 116)
m.addConstr(17*x0 + 5*x1 + 4*x2 + 3*x3 >= 116)
m.addConstr(15*x0**2 + 24*x3**2 >= 90)
m.addConstr(29*x2**2 + 24*x3**2 >= 45)
m.addConstr(18*x1**2 + 29*x2**2 >= 38)
m.addConstr(15*x0**2 + 18*x1**2 + 29*x2**2 >= 75)
m.addConstr(15*x0 + 18*x1 + 29*x2 + 24*x3 >= 75)
m.addConstr(-2*x0 + 9*x2 >= 0)
m.addConstr(6*x1 - 5*x2 >= 0)
m.addConstr(5*x1**2 + 4*x2**2 + 3*x3**2 <= 282)
m.addConstr(17*x0 + 5*x1 + 4*x2 <= 325)
m.addConstr(17*x0**2 + 4*x2**2 + 3*x3**2 <= 172)
m.addConstr(18*x1 + 24*x3 <= 130)
m.addConstr(29*x2 + 24*x3 <= 412)
m.addConstr(15*x0**2 + 29*x2**2 <= 183)
m.addConstr(15*x0 + 24*x3 <= 258)
m.addConstr(18*x1 + 29*x2 + 24*x3 <= 164)
m.addConstr(15*x0**2 + 18*x1**2 + 24*x3**2 <= 128)
m.addConstr(15*x0 + 18*x1 + 29*x2 <= 226)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

