
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin K
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B9
    x2 = model.addVar(name="x2", lb=0, integrality=1)  # milligrams of vitamin B3
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin D

    # Objective function
    model.setObjective(4*x0**2 + 6*x0*x1 + x0*x2 + 8*x0*x3 + x1**2 + 8*x1*x2 + 7*x1*x3 + 6*x2*x3 + 8*x3**2 + 5*x1 + 7*x2 + 4*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17*x0 <= 478)
    model.addConstr(15*x0 <= 413)
    model.addConstr(5*x1 <= 478)
    model.addConstr(18*x1 <= 413)
    model.addConstr(4*x2 <= 478)
    model.addConstr(29*x2 <= 413)
    model.addConstr(3*x3 <= 478)
    model.addConstr(24*x3 <= 413)
    model.addConstr(4*x2 + 3*x3 >= 96)
    model.addConstr(17*x0 + 5*x1 >= 91)
    model.addConstr(289*x0**2 + 9*x3**2 >= 105)
    model.addConstr(5*x1 + 4*x2 >= 116)
    model.addConstr(17*x0 + 5*x1 + 4*x2 + 3*x3 >= 116)
    model.addConstr(225*x0**2 + 576*x3**2 >= 90)
    model.addConstr(841*x2**2 + 576*x3**2 >= 45)
    model.addConstr(324*x1**2 + 841*x2**2 >= 38)
    model.addConstr(225*x0**2 + 324*x1**2 + 841*x2**2 >= 75)
    model.addConstr(15*x0 + 18*x1 + 29*x2 + 24*x3 >= 75)
    model.addConstr(-2*x0 + 9*x2 >= 0)
    model.addConstr(6*x1 - 5*x2 >= 0)
    model.addConstr(25*x1**2 + 16*x2**2 + 9*x3**2 <= 282)
    model.addConstr(17*x0 + 5*x1 + 4*x2 <= 325)
    model.addConstr(289*x0**2 + 16*x2**2 + 9*x3**2 <= 172)
    model.addConstr(18*x1 + 24*x3 <= 130)
    model.addConstr(29*x2 + 24*x3 <= 412)
    model.addConstr(225*x0**2 + 841*x2**2 <= 183)
    model.addConstr(15*x0 + 24*x3 <= 258)
    model.addConstr(18*x1 + 29*x2 + 24*x3 <= 164)
    model.addConstr(225*x0**2 + 324*x1**2 + 576*x3**2 <= 128)
    model.addConstr(15*x0 + 18*x1 + 29*x2 <= 226)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No optimal solution found.")

optimize_problem()
