
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
x1 = model.addVar(name="milligrams_of_potassium")
x2 = model.addVar(name="milligrams_of_vitamin_D")
x3 = model.addVar(name="milligrams_of_vitamin_B1")

# Set the objective function
model.setObjective(5.1*x1 + 6.54*x2 + 7.3*x3, GRB.MINIMIZE)

# Add constraints
model.addConstr(16*x1 + 5*x2 >= 20, name="digestive_support_index_12")
model.addConstr(16*x1 + 5*x2 + 8*x3 >= 20, name="digestive_support_index_123")
model.addConstr(2*x2 - 3*x3 >= 0, name="vitamin_constraint")
model.addConstr(7*x1 - 5*x2 >= 0, name="potassium_vitamin_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of potassium: {x1.x}")
    print(f"Milligrams of vitamin D: {x2.x}")
    print(f"Milligrams of vitamin B1: {x3.x}")
else:
    print("No optimal solution found.")
