
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of potassium
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin D
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B1

    # Define the objective function
    model.setObjective(5.1 * x1 + 6.54 * x2 + 7.3 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(16 * x1 + 5 * x2 >= 20, name="constraint1")
    model.addConstr(16 * x1 + 5 * x2 + 8 * x3 >= 20, name="constraint2")
    model.addConstr(2 * x2 - 3 * x3 >= 0, name="constraint3")
    model.addConstr(7 * x1 - 5 * x2 >= 0, name="constraint4")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of potassium: {x1.varValue}")
        print(f"Milligrams of vitamin D: {x2.varValue}")
        print(f"Milligrams of vitamin B1: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
