
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
    vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")

    # Set objective function
    m.setObjective(6.81 * fat + 7.65 * vitamin_b9 + 1.37 * vitamin_c + 2.1 * protein, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2.67 * fat + 4.62 * vitamin_b9 >= 12)
    m.addConstr(4.62 * vitamin_b9 + 0.06 * protein >= 8)
    m.addConstr(4.62 * vitamin_b9 + 1.83 * vitamin_c >= 12)
    m.addConstr(2.67 * fat + 1.83 * vitamin_c >= 14)
    m.addConstr(2.67 * fat + 1.83 * vitamin_c + 0.06 * protein >= 14)
    m.addConstr(5.1 * vitamin_c + 5.93 * protein <= 83)
    m.addConstr(0.05 * vitamin_b9 + 5.93 * protein <= 60)
    m.addConstr(6.54 * fat + 5.1 * vitamin_c <= 57)
    m.addConstr(6.54 * fat + 0.05 * vitamin_b9 + 5.1 * vitamin_c + 5.93 * protein <= 57)
    m.addConstr(2.67 * fat + 0.06 * protein <= 14)
    m.addConstr(2.67 * fat + 1.83 * vitamin_c <= 49)
    m.addConstr(4.62 * vitamin_b9 + 1.83 * vitamin_c <= 40)
    m.addConstr(4.62 * vitamin_b9 + 0.06 * protein <= 57)
    m.addConstr(1.83 * vitamin_c + 0.06 * protein <= 51)
    m.addConstr(2.67 * fat + 4.62 * vitamin_b9 <= 51)
    m.addConstr(2.67 * fat + 4.62 * vitamin_b9 + 0.06 * protein <= 41)
    m.addConstr(2.67 * fat + 4.62 * vitamin_b9 + 1.83 * vitamin_c + 0.06 * protein <= 41)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
