
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # grams of fat
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B9
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin C
    x4 = model.addVar(name="x4", lb=0)  # grams of protein

    # Objective function
    model.setObjective(6.81 * x1 + 7.65 * x2 + 1.37 * x3 + 2.1 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2.67 * x1 <= 57)
    model.addConstr(4.62 * x2 <= 57)
    model.addConstr(1.83 * x3 <= 57)
    model.addConstr(0.06 * x4 <= 57)
    model.addConstr(4.62 * x2 + 0.06 * x4 >= 8)
    model.addConstr(2.67 * x1 + 4.62 * x2 >= 12)
    model.addConstr(4.62 * x2 + 1.83 * x3 >= 12)
    model.addConstr(2.67 * x1 + 1.83 * x3 >= 14)
    model.addConstr(2.67 * x1 + 1.83 * x3 + 0.06 * x4 >= 14)
    model.addConstr(5.1 * x3 + 5.93 * x4 <= 83)
    model.addConstr(0.05 * x2 + 5.93 * x4 <= 60)
    model.addConstr(6.54 * x1 + 5.1 * x3 <= 57)
    model.addConstr(6.54 * x1 + 0.05 * x2 + 5.1 * x3 + 5.93 * x4 <= 57)
    model.addConstr(2.67 * x1 + 0.06 * x4 <= 14)
    model.addConstr(2.67 * x1 + 1.83 * x3 <= 49)
    model.addConstr(4.62 * x2 + 1.83 * x3 <= 40)
    model.addConstr(4.62 * x2 + 0.06 * x4 <= 57)
    model.addConstr(1.83 * x3 + 0.06 * x4 <= 51)
    model.addConstr(2.67 * x1 + 4.62 * x2 <= 51)
    model.addConstr(2.67 * x1 + 4.62 * x2 + 0.06 * x4 <= 41)
    model.addConstr(2.67 * x1 + 4.62 * x2 + 1.83 * x3 + 0.06 * x4 <= 41)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Objective: {model.objval}")
        print(f"x1 (grams of fat): {x1.varValue}")
        print(f"x2 (milligrams of vitamin B9): {x2.varValue}")
        print(f"x3 (milligrams of vitamin C): {x3.varValue}")
        print(f"x4 (grams of protein): {x4.varValue}")
    else:
        print("No optimal solution found.")

optimize_problem()
