
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_B7")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="calcium")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_D")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B4")


    # Set objective function
    m.setObjective(2.48 * x0 + 5.52 * x1 + 7.38 * x2 + 1.06 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11.54 * x0 + 0.78 * x3 >= 15, "c1")
    m.addConstr(6.22 * x1 + 6.28 * x2 >= 23, "c2")
    m.addConstr(11.54 * x0 + 6.28 * x2 >= 36, "c3")
    m.addConstr(6.28 * x2 + 0.78 * x3 >= 36, "c4")
    m.addConstr(11.54 * x0 + 6.22 * x1 >= 21, "c5")
    m.addConstr(11.54 * x0 + 6.22 * x1 + 6.28 * x2 + 0.78 * x3 >= 21, "c6")
    m.addConstr(-5 * x1 + 6 * x3 >= 0, "c7")
    m.addConstr(11.54 * x0 + 6.22 * x1 <= 121, "c8")
    m.addConstr(6.22 * x1 + 6.28 * x2 <= 51, "c9")
    m.addConstr(11.54 * x0 + 6.28 * x2 <= 46, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
