
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B7
    x2 = model.addVar(name='x2')  # milligrams of calcium
    x3 = model.addVar(name='x3')  # milligrams of vitamin D
    x4 = model.addVar(name='x4')  # milligrams of vitamin B4

    # Define the objective function
    model.setObjective(2.48 * x1 + 5.52 * x2 + 7.38 * x3 + 1.06 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11.54 * x1 + 0.78 * x4 >= 15)
    model.addConstr(6.22 * x2 + 6.28 * x3 >= 23)
    model.addConstr(11.54 * x1 + 6.28 * x3 >= 36)
    model.addConstr(6.28 * x3 + 0.78 * x4 >= 36)
    model.addConstr(11.54 * x1 + 6.22 * x2 >= 21)
    model.addConstr(11.54 * x1 + 6.22 * x2 + 6.28 * x3 + 0.78 * x4 >= 21)
    model.addConstr(-5 * x2 + 6 * x4 >= 0)
    model.addConstr(11.54 * x1 + 6.22 * x2 <= 121)
    model.addConstr(6.22 * x2 + 6.28 * x3 <= 51)
    model.addConstr(11.54 * x1 + 6.28 * x3 <= 46)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'milligrams of vitamin B7: {x1.varValue}')
        print(f'milligrams of calcium: {x2.varValue}')
        print(f'milligrams of vitamin D: {x3.varValue}')
        print(f'milligrams of vitamin B4: {x4.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
