
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cookies = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")
napkins = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_napkins")
lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
milk = m.addVar(vtype=gp.GRB.INTEGER, name="cartons_of_milk")
candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")


# Set objective function
m.setObjective(6.01 * cookies + 8.91 * napkins + 6.18 * lightbulbs + 3.04 * milk + 4.34 * candles, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * cookies + 1 * napkins + 5 * lightbulbs + 4 * milk + 8 * candles <= 164, "storage_space")
m.addConstr(5 * cookies + 2 * napkins + 8 * lightbulbs + 4 * milk + 1 * candles <= 99, "dollar_value")
m.addConstr(napkins + 5*lightbulbs >= 24)
m.addConstr(5*lightbulbs + 8*candles >= 10)
m.addConstr(5 * lightbulbs + 4 * milk >= 10)
m.addConstr(8 * cookies + 4 * milk >= 16)
m.addConstr(8 * cookies + napkins >= 24)

m.addConstr(napkins + 5 * lightbulbs + 4 * milk >= 23)
m.addConstr(5 * lightbulbs + 4 * milk + 8 * candles >= 23)
m.addConstr(8 * cookies + napkins + 5 * lightbulbs >= 23)
m.addConstr(napkins + 5 * lightbulbs + 8 * candles >= 23)
m.addConstr(napkins + 4 * milk + 8 * candles >= 23)
m.addConstr(8 * cookies + napkins + 4 * milk >= 23)

m.addConstr(napkins + 5 * lightbulbs + 4 * milk >= 27)
m.addConstr(5 * lightbulbs + 4 * milk + 8 * candles >= 27)
m.addConstr(8 * cookies + napkins + 5 * lightbulbs >= 27)
m.addConstr(napkins + 5 * lightbulbs + 8 * candles >= 27)
m.addConstr(napkins + 4 * milk + 8 * candles >= 27)
m.addConstr(8 * cookies + napkins + 4 * milk >= 27)

m.addConstr(napkins + 5 * lightbulbs + 4 * milk >= 29)
m.addConstr(5 * lightbulbs + 4 * milk + 8 * candles >= 29)
m.addConstr(8 * cookies + napkins + 5 * lightbulbs >= 29)
m.addConstr(napkins + 5 * lightbulbs + 8 * candles >= 29)
m.addConstr(napkins + 4 * milk + 8 * candles >= 29)
m.addConstr(8 * cookies + napkins + 4 * milk >= 29)


m.addConstr(5 * cookies + candles >= 9)
m.addConstr(8 * lightbulbs + 4 * milk >= 18)
m.addConstr(2 * napkins + 4 * milk >= 15)
m.addConstr(8 * lightbulbs + candles >= 17)
m.addConstr(5 * cookies + 4 * milk + candles >= 16)
m.addConstr(5 * cookies + 8 * lightbulbs + 4 * milk >= 16)
m.addConstr(2 * napkins + 4 * milk + candles >= 16)
m.addConstr(5 * cookies + 4 * milk + candles >= 9)
m.addConstr(5 * cookies + 8 * lightbulbs + 4 * milk >= 9)
m.addConstr(2 * napkins + 4 * milk + candles >= 9)
m.addConstr(5 * cookies + 4 * milk + candles >= 18)
m.addConstr(5 * cookies + 8 * lightbulbs + 4 * milk >= 18)
m.addConstr(2 * napkins + 4 * milk + candles >= 18)
m.addConstr(5 * cookies + 2 * napkins + 8 * lightbulbs + 4 * milk + candles >= 18)
m.addConstr(2 * lightbulbs - candles >= 0)
m.addConstr(5 * lightbulbs + 4 * milk <= 130)
m.addConstr(5 * lightbulbs + 8 * candles <= 152)
m.addConstr(8 * cookies + 8 * candles <= 48)
m.addConstr(2 * napkins + 8 * lightbulbs + candles <= 59)
m.addConstr(5 * cookies + 8 * lightbulbs + 4 * milk <= 43)
m.addConstr(5 * cookies + 2 * napkins + 8 * lightbulbs <= 77)
m.addConstr(5 * cookies + 2 * napkins + candles <= 42)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

