
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("Military_Planning")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")
    x1 = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
    x2 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")


    # Set objective function
    m.setObjective(2*x0 + 6*x1 + 5*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15*x0 + 17*x1 + 5*x2 <= 160, "Fuel_Constraint")
    m.addConstr(1*x0 + 12*x1 + 3*x2 <= 421, "Offensive_Capability_Constraint")  # Corrected constraint
    m.addConstr(15*x0 + 17*x1 >= 35, "Min_Fuel_x0_x1")
    m.addConstr(x0 + 12*x1 <= 196, "Max_Offensive_x0_x1")
    m.addConstr(x0 + 3*x2 <= 283, "Max_Offensive_x0_x2")
    m.addConstr(x0 + 12*x1 + 3*x2 <= 247, "Max_Offensive_Total1")
    m.addConstr(17*x1 + 5*x2 <= 140, "Max_Fuel_x1_x2")
    m.addConstr(15*x0 + 17*x1 + 5*x2 <= 96, "Max_Fuel_Total")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('air_defense_batteries:', x0.x)
        print('signal_platoons:', x1.x)
        print('medical_platoons:', x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
