
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")
x1 = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
x2 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")

# Objective function
m.setObjective(2*x0 + 6*x1 + 5*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(15*x0 + 17*x1 >= 35, "fuel_demand_min")
m.addConstr(x0 + 12*x1 <= 196, "offensive_capability_air_signal")
m.addConstr(x0 + 3*x2 <= 283, "offensive_capability_air_medical")
m.addConstr(x0 + 12*x1 + 3*x2 <= 247, "total_offensive_capability_max")
m.addConstr(17*x1 + 5*x2 <= 140, "fuel_demand_signal_medical")
m.addConstr(15*x0 + 17*x1 + 5*x2 <= 96, "total_fuel_demand")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Air Defense Batteries: {x0.x}")
    print(f"Signal Platoons: {x1.x}")
    print(f"Medical Platoons: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
