
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="air_defense_batteries", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="signal_platoons", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="medical_platoons", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(2*x0 + 6*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x0 + 17*x1 >= 35, name="fuel_demand_constraint")
m.addConstr(x0 + 12*x1 <= 196, name="offensive_capability_rating_constraint_1")
m.addConstr(x0 + 3*x2 <= 283, name="offensive_capability_rating_constraint_2")
m.addConstr(x0 + 12*x1 + 3*x2 <= 247, name="offensive_capability_rating_constraint_3")
m.addConstr(17*x1 + 5*x2 <= 140, name="fuel_demand_constraint_2")
m.addConstr(15*x0 + 17*x1 + 5*x2 <= 96, name="total_fuel_demand_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Air defense batteries: {x0.varValue}")
    print(f"Signal platoons: {x1.varValue}")
    print(f"Medical platoons: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
