
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
paul = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Paul")
bobby = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bobby")
mary = m.addVar(lb=0, vtype=GRB.INTEGER, name="Mary")
george = m.addVar(lb=0, vtype=GRB.INTEGER, name="George")
peggy = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Peggy")
ringo = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Ringo")


# Set objective
obj = 4.85*paul*bobby + 9.98*paul*george + 4.12*paul*ringo + 6.23*bobby**2 + 1.98*bobby*mary + 3.64*bobby*george + 8.64*bobby*ringo + 8.33*mary*george + 9.28*mary*peggy + 8.28*mary*ringo + 4.19*george**2 + 2.32*george*peggy + 7.98*peggy**2 + 5.46*peggy*ringo + 7.15*ringo**2 + 6.18*paul + 5.24*bobby + 1.79*mary + 1.0*george + 6.44*peggy + 4.89*ringo

m.setObjective(obj, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*mary + 1*ringo >= 8)
m.addConstr(2*paul + 3*bobby >= 3)
m.addConstr(2*paul + 4*mary >= 5)
m.addConstr(3*bobby**2 + 1*peggy**2 >= 3)
m.addConstr(1*peggy**2 + 1*ringo**2 >= 4)
m.addConstr(3*bobby + 4*mary >= 2)
m.addConstr(3*bobby**2 + 1*george**2 >= 3)
m.addConstr(1*george**2 + 1*ringo**2 >= 2)
m.addConstr(2*paul + 1*peggy >= 5)
m.addConstr(3*bobby + 4*mary + 1*ringo >= 4)
m.addConstr(2*paul + 4*mary + 1*peggy >= 4)
m.addConstr(2*paul + 3*bobby + 1*peggy >= 4)
m.addConstr(3*bobby**2 + 1*george**2 + 1*peggy**2 >= 4)
m.addConstr(2*paul**2 + 3*bobby**2 + 1*ringo**2 >= 4)
m.addConstr(3*bobby + 4*mary + 1*ringo >= 4)
m.addConstr(2*paul**2 + 4*mary**2 + 1*peggy**2 >= 4)
m.addConstr(2*paul + 3*bobby + 1*peggy >= 4)
m.addConstr(3*bobby + 1*george + 1*peggy >= 4)
m.addConstr(2*paul + 3*bobby + 1*ringo >= 4)
m.addConstr(3*bobby + 4*mary + 1*ringo >= 4)
m.addConstr(2*paul**2 + 4*mary**2 + 1*peggy**2 >= 4)
m.addConstr(2*paul + 3*bobby + 1*peggy >= 4)
m.addConstr(3*bobby + 1*george + 1*peggy >= 4)
m.addConstr(2*paul + 3*bobby + 1*ringo >= 4)
m.addConstr(3*bobby**2 + 4*mary**2 + 1*ringo**2 >= 8)
m.addConstr(2*paul + 4*mary + 1*peggy >= 8)
m.addConstr(2*paul + 3*bobby + 1*peggy >= 8)
m.addConstr(3*bobby**2 + 1*george**2 + 1*peggy**2 >= 8)
m.addConstr(2*paul + 3*bobby + 1*ringo >= 8)
m.addConstr(3*bobby**2 + 4*mary**2 + 1*ringo**2 >= 6)
m.addConstr(2*paul**2 + 4*mary**2 + 1*peggy**2 >= 6)
m.addConstr(2*paul + 3*bobby + 1*peggy >= 6)
m.addConstr(3*bobby + 1*george + 1*peggy >= 6)
m.addConstr(2*paul**2 + 3*bobby**2 + 1*ringo**2 >= 6)
m.addConstr(2*bobby**2 - 5*mary**2 - 8*ringo**2 >= 0)
m.addConstr(4*mary**2 + 1*ringo**2 <= 22)
m.addConstr(1*peggy + 1*ringo <= 43)
m.addConstr(3*bobby**2 + 4*mary**2 <= 50)
m.addConstr(3*bobby**2 + 1*george**2 <= 14)
m.addConstr(2*paul + 1*ringo <= 29)
m.addConstr(3*bobby + 1*ringo <= 51)
m.addConstr(4*mary + 1*peggy <= 47)
m.addConstr(3*bobby + 1*peggy <= 17)
m.addConstr(1*george + 1*ringo <= 48)
m.addConstr(2*paul + 4*mary <= 46)
m.addConstr(2*paul + 1*george <= 39)
m.addConstr(4*mary + 1*george <= 30)
m.addConstr(3*bobby + 1*george + 1*ringo <= 27)
m.addConstr(2*paul + 4*mary + 1*peggy <= 45)
m.addConstr(4*mary**2 + 1*george**2 + 1*ringo**2 <= 38)
m.addConstr(3*bobby + 4*mary + 1*george <= 45)
m.addConstr(3*bobby + 1*george + 1*peggy <= 37)
m.addConstr(3*bobby + 4*mary + 1*peggy <= 51)
m.addConstr(2*paul + 1*george + 1*ringo <= 32)
m.addConstr(4*mary + 1*george + 1*peggy <= 23)
m.addConstr(2*paul + 3*bobby + 4*mary + 1*george + 1*peggy + 1*ringo <= 23)


# Optimize model
m.optimize()

#print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
